local assets=
{
	Asset("ANIM", "anim/batteries.zip"),
	Asset("ATLAS", "images/inventoryimages/batteries.xml"),
    Asset("IMAGE", "images/inventoryimages/batteries.tex"),
}

local prefabs =
{

}

local function OnHit(inst, owner, target)
    inst:Remove()    
end

local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("batteries")
    inst.AnimState:SetBuild("batteries")
    inst.AnimState:PlayAnimation("idle", false)
    	
	inst:AddTag("projectile")
	
		
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst:AddComponent("inspectable")
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/batteries.xml"

	return inst
end



STRINGS.NAMES.BATTERIES = "Batteries"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BATTERIES = "It has a radioactive sign, should I be holding it?"


return Prefab( "common/inventory/batteries", fncommon, assets)
